import type { RouteRecordRaw } from 'vue-router'
import AppLayout from '@/components/layout/Index.vue'

export const routes: Array<RouteRecordRaw> = [
  {
    path: '/student/lab',
    component: AppLayout,
    props: { sidebar: false },
    children: [
      { path: '', component: () => import('./views/Index.vue') },
      { path: 'report/:id', component: () => import('./views/Report.vue'), props: true },
      { path: 'report/view/:id', component: () => import('./views/ReportView.vue'), props: true },
      { path: 'competition', component: () => import('./views/Competition.vue') },
    ],
  },
]
