import { defineStore } from 'pinia'
import { getMapList } from '@/api/base'

interface State {
  mapList: IMapState[]
}
interface IMapState {
  id: string
  key: string
  name: string
  remark: string
  values: IValuesList[]
}

interface IValuesList {
  data_dictionary_id: string
  id: string
  label: string
  remark: string
  sort: string
  value: string
}

export const useMapStore = defineStore('map', {
  state: (): State => {
    return {
      mapList: [],
    }
  },
  getters: {
    getMapValuesByKey: (state) => {
      return (key: string) => state.mapList.find((map) => map.key === key)?.values || []
    },
  },
  actions: {
    async getMapList() {
      const res = await getMapList()
      this.mapList = res.data || []
    },
  },
})
