const appConfigList = [
  {
    system: 'ai',
    title: '人工智能应用实践教学平台',
    logo: '/logo.svg',
    hosts: ['saas-dml-web'],
    dmlURL: import.meta.env.VITE_DML_PRO_URL,
  },
  {
    system: 'dml',
    title: '数字技能实践教学平台',
    logo: '/logo.svg',
    hosts: ['saas-dml-web'],
    dmlURL: import.meta.env.VITE_DML_PRO_URL,
  },
  {
    system: 'default',
    title: '商务数据分析',
    logo: '/logo.svg',
    hosts: ['saas-lab'],
  },
  {
    system: 'gdrtvu',
    title: '金融数字产品营销',
    logo: '/logo.svg',
    hosts: ['saas-lab.segedu.cn'],
    dmlURL: import.meta.env.VITE_DML_PRO_URL,
  },
  {
    system: 'x',
    title: '1+X实训平台',
    logo: '/logo.svg',
    hosts: ['saas-x'],
    studentMenus: [
      { name: '首页', path: '/' },
      { name: '我的实验', path: '/student/lab' },
      { name: '理论学习', path: import.meta.env.VITE_SAAS_LEARN_URL },
    ],
    adminMenus: [
      { name: '首页', path: '/' },
      {
        name: '我的实验',
        path: '/admin/lab',
        tag: ['v1-backend-experiment', 'v1-teacher'],
        children: [
          { name: '实验管理', path: '/admin/lab/experiment', tag: 'v1-backend-experiment' },
          { name: '案例原文管理', path: '/admin/lab/case', tag: 'teacher-experiment-cases' },
          { name: '实验指导书管理', path: '/admin/lab/book', tag: 'v1-teacher-book' },
          { name: '实验操作视频管理', path: '/admin/lab/video', tag: 'v1-teacher-video' },
          { name: '实验讨论交流', path: '/admin/lab/discuss', tag: 'v1-teacher-discussion' },
          { name: '实验成绩管理', path: '/admin/lab/score', tag: 'v1-teacher-record' },
        ],
      },
    ],
    // liveMonitor: true,
  },
  {
    system: 'game',
    title: '商业数据分析竞赛平台',
    hosts: ['saas-game'],
  },
  {
    system: 'swsjfxs',
    title: '商务数据分析师',
    logo: '/images/logo_swsjfxs.png',
    favicon: '/images/favicon_swsjfxs.png',
    hosts: ['swsjfxs'],
    studentMenus: [
      { name: '首页', path: '/' },
      { name: '我的大赛', path: '/student/contest' },
      { name: '大赛成绩查询', path: '/student/contest/score' },
    ],
    xTrainLabel: '商务数据分析理论训练',
    labTrainLabel: '商务数据分析实操训练',
    xExamLabel: '商务数据分析理论考试',
    labExamLabel: '商务数据分析实操考试',
    loginURL: import.meta.env.VITE_SWSJFXS_LOGIN_URL,
  },
  {
    system: 'swsjfxs',
    title: '商务数据分析师',
    logo: '/images/logo_swsjfxs.png',
    favicon: '/images/favicon_swsjfxs.png',
    hosts: ['saas-lab-bda'],
    studentMenus: [
      { name: '首页', path: '/' },
      { name: '我的大赛', path: '/student/contest' },
      { name: '大赛成绩查询', path: '/student/contest/score' },
    ],
    xTrainLabel: '理论训练',
    labTrainLabel: '实操训练',
    xExamLabel: '理论考试',
    labExamLabel: '实操考试',
    loginURL: import.meta.env.VITE_SWSJFXS_LOGIN_URL,
    hideAvailableEvents: true, // 隐藏可参与赛项
    hidePracticalTestPaper: true, // 隐藏实操试卷
    hideContestToolbar: true, // 隐藏大赛工具栏
  },
  {
    system: 'amo',
    title: '全媒体运营师',
    logo: '/images/logo_swsjfxs.png',
    favicon: '/images/favicon_swsjfxs.png',
    hosts: ['saas-lab-amo'],
    studentMenus: [
      { name: '首页', path: '/' },
      { name: '我的大赛', path: '/student/contest' },
      { name: '大赛成绩查询', path: '/student/contest/score' },
    ],
    xTrainLabel: '理论训练',
    labTrainLabel: '实操训练',
    xExamLabel: '理论考试',
    labExamLabel: '实操考试',
    loginURL: import.meta.env.VITE_SWSJFXS_LOGIN_URL,
    hideAvailableEvents: true, // 隐藏可参与赛项
    hidePracticalTestPaper: true, // 隐藏实操试卷
    hideContestToolbar: true, // 隐藏大赛工具栏
  },
  {
    system: 'default',
    title: '商业数据分析与应用大赛',
    logo: '/logo.svg',
    // logo: '/images/logo_swsjfxs.png',
    // favicon: '/images/favicon_swsjfxs.png',
    hosts: ['saas-lab-bda2'],
    studentMenus: [
      { name: '首页', path: '/' },
      { name: '我的大赛', path: '/student/contest' },
      // { name: '大赛成绩查询', path: '/student/contest/score' }
    ],
    xTrainLabel: '理论训练',
    labTrainLabel: '实操训练',
    xExamLabel: '理论考试',
    labExamLabel: '实操考试',
    // loginURL: import.meta.env.VITE_SWSJFXS_LOGIN_URL,
    hideAvailableEvents: true, // 隐藏可参与赛项
    hidePracticalTestPaper: true, // 隐藏实操试卷
    hideContestToolbar: true, // 隐藏大赛工具栏
  },
  {
    system: 'nac',
    title: '首届网络视听行业职业技能大赛',
    logo: '/images/nac_logo.png',
    logoWidth: '40px',
    // logo: 'https://webapp-pub.ezijing.com/website/base/images/logo_swsjfxs.png',
    // favicon: 'https://webapp-pub.ezijing.com/website/base/images/favicon_swsjfxs.png',
    hosts: ['saas-lab-nac'],
    studentMenus: [
      { name: '首页', path: '/' },
      { name: '我的大赛', path: '/student/contest' },
      // { name: '大赛成绩查询', path: '/student/contest/score' }
    ],
    xTrainLabel: '理论训练',
    labTrainLabel: '实操训练',
    xExamLabel: '理论考试',
    labExamLabel: '实操考试',
    // loginURL: import.meta.env.VITE_SWSJFXS_LOGIN_URL,
    hideAvailableEvents: true, // 隐藏可参与赛项
    hidePracticalTestPaper: true, // 隐藏实操试卷
    hideContestToolbar: true, // 隐藏大赛工具栏
  },
]

export function useAppConfig() {
  const found = appConfigList.find((item) => {
    return item.hosts.find((host) => location.host.split('.').includes(host))
  })

  const appConfig = found || appConfigList[1]

  return { ...appConfig }
}
