export interface ContestScoreItem {
  id: string
  name: string
  host_unit_id: string
  type: string
  publish_status: string
  updated_time: string
  host_unit_id_name: string
  type_name: string
  publish_status_name: string
  teachers: string[]
  expert_count: number
  all_competitor_count: number
  complete_competitor_count: number
  checked_competitor_count: number
}

export interface ContestantScoreItem {
  id: string
  competition_id: string
  student_id: string
  login_id: string
  grade: string
  train_count: string
  score: string
  score_status: string
  updated_time: string
  specialty_id: string
  specialty_id_name: string
  class_id: string
  class_id_name: string
  student_name: string
  sno_number: string
  organ_id: string
  organ_id_name: string
  gender: string
  competition_id_name: string
  competition_is_more_status: string
  competition_rule_type: string
  competition_rubric: ScoreBook
  checked_count: number
  need_check_count: number
  checked_flag: true
  checked_flag_name: string
  score_name: string
  publish_status: string
  publish_status_name: string
  check_details_experts: CheckExpert[]
  check_details: CheckItem[]
}

export interface CheckItem {
  id: string
  name: string
  type: string
  old_score: string
  ratio: string
  type_name: string
  score: Record<string, string>
}

export interface CheckExpert {
  sso_id: string
  name: string
}

export interface ScoreBook {
  name: string
  url: string
}
