export interface CaseItem {
  created_operator_name: string
  created_time: string
  delete_time: string
  experiment_id: string
  id: string
  name: string
  content: string
  status: string
  status_name: string
  type_name: string
  type: string
  times: string
  updated_operator_name: string
  updated_time: string
  experiments?: ExperimentItem[]
}

export interface CaseFormData {
  id?: string
  name: string
  type: string
  times: string
  content: string
  steps?: CaseStep[]
}

export type CaseCreateItem = CaseFormData

export type CaseUpdateItem = CaseCreateItem & { id: string }

export interface ExperimentItem {
  id: string
  name: string
  type: string
  type_name: string
  created_time: string
  status: string
  created_operator_name: string
  updated_time: string
  updated_operator: string
  updated_operator_name: string
}

export interface CaseStep {
  id: string
  type: 1 | 2 | 3 // 1: 案例原文, 2: 任务, 3: 案例总结
  name: string
  content?: string
  config?: any
}
