// import fs from 'node:fs'
// import path from 'node:path'
import { fileURLToPath, URL } from 'node:url'

import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import checker from 'vite-plugin-checker'
import AutoImport from 'unplugin-auto-import/vite'
import ReactivityTransform from '@vue-macros/reactivity-transform/vite'
import mkcert from 'vite-plugin-mkcert'

export default defineConfig(() => ({
  // base: mode === 'prod' ? 'https://webapp-pub.ezijing.com/website/prod/saas-lab/' : '/',
  plugins: [
    mkcert(),
    vue(),
    AutoImport({
      imports: ['vue', 'vue-router', '@vueuse/core', '@vueuse/math'],
      dts: true,
      eslintrc: { enabled: true },
    }),
    ReactivityTransform(),
    checker({ vueTsc: true, eslint: { useFlatConfig: true, lintCommand: 'eslint "./src/**/*.{vue,js,jsx,ts,tsx}"' } }),
  ],
  server: {
    open: true,
    host: 'dev.ezijing.com',
    // https: {
    //   key: fs.readFileSync(path.join(__dirname, './https/ezijing.com.key')),
    //   cert: fs.readFileSync(path.join(__dirname, './https/ezijing.com.pem'))
    // },
    proxy: {
      // '/api/lab': {
      //   target: 'http://local-com-resource-api.frontend.ezijing.com',
      //   changeOrigin: true,
      //   rewrite: (path) => path.replace(/^\/api\/lab/, ''),
      // },
      // '/api/resource': {
      //   target: 'http://com-resource-admin-test.ezijing.com',
      //   changeOrigin: true,
      //   rewrite: path => path.replace(/^\/api\/resource/, '')
      // },
      '/api': 'https://saas-lab.ezijing.com',
    },
  },
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./src', import.meta.url)),
    },
  },
}))
