import { getQuestionTags, getQuestionGroup, getQuestionMaterials, getQuestionEvents } from '../api'

// 标签类型
export interface TagType {
  id: string
  name: string
  count: string
}

// 群组类型
export interface GroupType {
  id: string
  name: string
  count: string
}

export interface MaterialType {
  id: string
  name: string
  type: string
}

// 事件类型
interface EventType {
  id: string
  name: string
}

// 所有标签
const tagList = ref<TagType[]>([])
export function useTag(experiment_id: string) {
  function fetchTagList() {
    getQuestionTags({ experiment_id }).then((res: any) => {
      tagList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!tagList.value?.length) fetchTagList()
  })
  return { fetchTagList, tagList }
}

// 所有群组
const groupList = ref<GroupType[]>([])
export function useGroup(experiment_id: string) {
  function fetchGroupList() {
    getQuestionGroup({ experiment_id }).then((res: any) => {
      groupList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!groupList.value?.length) fetchGroupList()
  })
  return { fetchGroupList, groupList }
}

// 所有资料
const materialList = ref<MaterialType[]>([])
export function useMaterial(experiment_id: string, type = '') {
  function fetchMaterialList() {
    getQuestionMaterials({ experiment_id, type }).then((res: any) => {
      materialList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!materialList.value?.length) fetchMaterialList()
  })
  return { fetchMaterialList, materialList }
}

// 所有事件
const eventList = ref<EventType[]>([])
export function useEvent(experiment_id: string) {
  function fetchMetaEventList() {
    getQuestionEvents({ experiment_id }).then((res: any) => {
      eventList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!eventList.value?.length) fetchMetaEventList()
  })
  return { fetchMetaEventList, eventList }
}
