import { getExperimentList } from '../api'

export interface ExperimentType {
  id: string
  name: string
}

export function useGetExperimentList() {
  const experiments = ref<ExperimentType[]>([])
  function updateExperiments(courseId?: string) {
    getExperimentList({ course_id: courseId }).then((res: any) => {
      experiments.value = res.data
    })
  }
  return { experiments, updateExperiments }
}
