import httpRequest from '@/utils/axios'

// 获取赛项成绩列表
export function getContestScoreList(params?: { competition_id?: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/lab/v1/expert/score/list', { params })
}

// 获取筛选条件
export function getFilterList() {
  return httpRequest.get('/api/lab/v1/expert/score/condition')
}

// 获取选手列表
export function getContestantsList(params: { competition_id: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/lab/v1/expert/score/competitors', { params })
}

// 发布成绩
export function publishScore(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/expert/score/publish', data)
}
