import httpRequest from '@/utils/axios'

// 获取大赛评分列表
export function getCheckList(params?: {
  competition_id?: string
  check_status?: string
  organ_id?: string
  student_name?: string
  login_id?: string
  page?: number
  'per-page'?: number
}) {
  return httpRequest.get('/api/lab/v1/expert/check/list', { params })
}

// 获取筛选条件
export function getFilterList(params?: { leader?: number }) {
  return httpRequest.get('/api/lab/v1/expert/check/condition', { params })
}

// 大赛评分详情
export function getCheckView(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/expert/check/view', { params })
}

// 评分
export function submitScore(data: { id: string; scores: string }) {
  return httpRequest.post('/api/lab/v1/expert/check/set-score', data)
}

// 同步1+X考试成绩
export function syncExam(data: { competition_id: string; detail_id: string }) {
  return httpRequest.post('/api/lab/v1/expert/check/sync-exam', data)
}

// 批量导入考试成绩
export function importExam(data: { competition_id: string; file: File }) {
  return httpRequest.post('/api/lab/v1/expert/check/import-exam', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

// 批量导入完整评分
export function importScore(data: { competition_id: string; file: File }) {
  return httpRequest.post('/api/lab/v1/expert/check/import-score', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

// 获取大赛学员提交报告列表
export function getReportList(params: { competition_id: string; student_id: string }) {
  return httpRequest.get('/api/lab/v1/expert/report/list', { params })
}

// 获取学员的直播记录
export function getLiveList(params: { experiment_id: string; student_id: string }) {
  return httpRequest.get('/api/lab/v1/expert/check/stu-live-practice-records', { params })
}
