import httpRequest from '@/utils/axios'
import type { ExperimentCreateItem } from './types'

// 获取实验列表
export function getExperimentList(params?: { name?: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/experiment/list', { params })
}

// 获取实验详情
export function getExperiment(params: { experiment_id: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/experiment/view', { params })
}

// 创建实验
export function createExperiment(data: ExperimentCreateItem) {
  return httpRequest.post('/api/resource/v1/backend/experiment/create', data)
}

// 更新实验
export function updateExperiment(data: ExperimentCreateItem) {
  return httpRequest.post('/api/resource/v1/backend/experiment/update', data)
}

// 获取课程实验列表
export function getCourseExperimentList(params: { course_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment/experiments', { params })
}
// 获取实验课程列表
export function getExperimentCourseList(params: { organ_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment/courses', { params })
}
// 获取实验指导老师列表
export function getExperimentTeacherList(params: { organ_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment/teachers', { params })
}
// 获取实验关联班级列表
export function getExperimentClassList(params: { experiment_id: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/experiment/class-add', { params })
}
// 实验关联班级
export function experimentAddClass(data: { experiment_id: string; classes_id: string; type: 'add' | 'delete' }) {
  return httpRequest.post('/api/resource/v1/backend/experiment/class-add', data)
}

// 获取班级学生列表
export function getClassStudentList(params: { class_id: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/experiment/class-students', { params })
}

// 获取班级小组列表
export function getExperimentClassGroupsList(params: { experiment_id: string; class_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment/class-teams', { params })
}

// 获取实验小组
export function getExperimentGroup(params: { team_id: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/experiment/team-view', { params })
}

// 新增实验小组
export function experimentAddClassGroup(data: { experiment_id: string; class_id: string; name: string }) {
  return httpRequest.post('/api/resource/v1/backend/experiment/team-add', data)
}

// 实验小组添加学生
export function experimentGroupAddStudent(data: { team_id: string; students_id: string; type: 'add' | 'delete' }) {
  return httpRequest.post('/api/resource/v1/backend/experiment/team-add-student', data)
}

// 获取实验关联班级列表
export function getExperimentGroupStudentList(params: { team_id: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/experiment/team-add-student', { params })
}

// 获取实验成绩规则
export function getExperimentGradeRule(params: { experiment_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment-score-rule/detail', { params })
}
// 更新实验成绩规则
export function updateExperimentGradeRule(data: { experiment_id: string; is_show: string; rule_list: string }) {
  return httpRequest.post('/api/resource/v1/backend/experiment-score-rule/save', data)
}

// 获取实验报告规则
export function getExperimentReportRule(params: { experiment_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment-report/detail', { params })
}
// 更新实验报告规则
export function updateExperimentReportRule(data: {
  experiment_id: string
  report_upload_way: number
  detail_list: string
}) {
  return httpRequest.post('/api/resource/v1/backend/experiment-report/save', data)
}

// 获取旅程配置
export function getTripConfig(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/itinerary-config/detail', { params })
}

// 更新旅程配置
export function updateTripConfig(data: { experiment_id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/itinerary-config/save', data, {
    headers: { 'Content-Type': 'application/json' },
  })
}

// 获取实验下的所有用户属性
export function getMetaUserAttrList(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/meta-member/all', { params })
}
// 获取实验下的所有事件
export function getMetaEventList(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/meta-event/all', { params })
}

// 获取实验下的所有标签
export function getTagList(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/tag/all', { params })
}

// 获取实验下的所有群组
export function getGroupList(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/group/all', { params })
}

// 获取实验下的所有连接
export function getConnectionList(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/connection/all', { params })
}

// 获取实验下的所有资料
export function getMaterialList(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/marketing-material/all', { params })
}

// 创建题
export function updateQuestions(data: { experiment_id: string; module: string; questions: any }) {
  return httpRequest.post('/api/resource/v1/backend/experiment-question/save', data)
}

// 获取题
export function getQuestions(data: { experiment_id: string; types?: any }) {
  return httpRequest.post('/api/resource/v1/backend/experiment-question/list', data)
}

// 试题获取老师创建的标签
export function getQuestionTags(params: { experiment_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment-question/tags2', { params })
}

// 试题获取群组
export function getQuestionGroup(params: { experiment_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment-question/groups', { params })
}

// 试题获取营销资料
export function getQuestionMaterials(params: { experiment_id: string; type: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment-question/materials', { params })
}

// 试题获取事件
export function getQuestionEvents(params: { experiment_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment-question/events', { params })
}

// 获取Excel总条数
export function getExcelTotalLine(data: { file: File }) {
  return httpRequest.post('/api/lab/v1/common/file/get-excel-total-line', data, {
    headers: { 'Content-Type': 'multipart/form-data' },
  })
}

// 判断是否维护了自动生成数据
export function checkAutoGenerateData(params: { experiment_id: string; event_id?: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment-question/check-auto-generate-data', { params })
}

// 获取实验下的所有理论考试
export function getAllExamList(params: {
  project: string
  q?: string
  name?: string
  page?: number
  'per-page'?: number
}) {
  return httpRequest.get('/api/resource/v1/backend/exam/search-all-exam', { params })
}
// 获取实验的理论考试列表
export function getExamList(params: { experiment_id: string; type: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment/exam-list', { params })
}
// 更新实验的理论考试
export function updateExam(data: { experiment_id: string; exam_id: string }) {
  return httpRequest.post('/api/resource/v1/backend/experiment/exam-save', data)
}
// 删除实验的理论考试
export function deleteExam(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/backend/experiment/exam-delete', data)
}
// 获取实验下的所有理论考试
export function getScoreExamList(params: { experiment_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment-score-rule/exams', { params })
}

// 复制实验
export function copyExperiment(data: { experiment_id: string }) {
  return httpRequest.post('/api/resource/v1/backend/experiment/copy', data)
}

// 删除实验
export function deleteExperiment(data: { experiment_id: string }) {
  return httpRequest.post('/api/resource/v1/backend/experiment/delete', data)
}

// 获取实验成绩规则
export function getLiveCommodity(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-commodity/all', { params })
}

// 获取实验大赛规则
export function getCompetitionRule(params: { experiment_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/experiment-competition-rule/detail', { params })
}

// 保存实验大赛规则
export function saveCompetitionRule(data: {
  experiment_id: string
  name: string
  start_time: string
  end_time: string
  questions: string
}) {
  return httpRequest.post('/api/resource/v1/backend/experiment-competition-rule/save', data)
}
