import {
  getMetaUserAttrList,
  getMetaEventList,
  getTagList,
  getGroupList,
  getConnectionList,
  getMaterialList
} from '../api'

// 用户属性类型
export interface AttrType {
  id: string
  name: string
  type: string
  format: string
  english_name: string
  pinyin: string
}
// 事件类型
interface MetaEventType {
  id: string
  name: string
  english_name: string
  pinyin: string
  event_attrs: AttrType[]
}

// 标签类型
export interface TagType {
  id: string
  name: string
}

// 群组类型
export interface GroupType {
  id: string
  name: string
}

// 连接类型
export interface ConnectionType {
  id: string
  name: string
  type: string
  status: '0' | '1'
  config_attributes: any
}

export interface MaterialType {
  id: string
  name: string
}

// 所有用户属性
const userAttrList = ref<AttrType[]>([])
export function useUserAttr(experiment_id: string) {
  function fetchUserAttrList() {
    getMetaUserAttrList({ experiment_id }).then((res: any) => {
      userAttrList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!userAttrList.value?.length) fetchUserAttrList()
  })
  return { fetchUserAttrList, userAttrList }
}

// 所有事件
const metaEventList = ref<MetaEventType[]>([])
export function useMetaEvent(experiment_id: string) {
  function fetchMetaEventList() {
    getMetaEventList({ experiment_id }).then((res: any) => {
      metaEventList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!metaEventList.value?.length) fetchMetaEventList()
  })
  return { fetchMetaEventList, metaEventList }
}

// 所有标签
const tagList = ref<TagType[]>([])
export function useTag(experiment_id: string) {
  function fetchTagList() {
    getTagList({ experiment_id }).then((res: any) => {
      tagList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!tagList.value?.length) fetchTagList()
  })
  return { fetchTagList, tagList }
}

// 所有群组
const groupList = ref<GroupType[]>([])
export function useGroup(experiment_id: string) {
  function fetchGroupList() {
    getGroupList({ experiment_id }).then((res: any) => {
      groupList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!groupList.value?.length) fetchGroupList()
  })
  return { fetchGroupList, groupList }
}

// 所有连接
const connectionList = ref<ConnectionType[]>([])
export function useConnection(experiment_id: string) {
  function fetchConnectionList() {
    getConnectionList({ experiment_id }).then((res: any) => {
      connectionList.value = res.data.items.map((item: any) => {
        const attrs = item.config_attributes
        const name = Array.isArray(attrs) ? attrs.find((item: any) => item.prop === 'name')?.value : attrs.name
        return { ...item, config_attributes: attrs, name }
      })
    })
  }
  onMounted(() => {
    if (!connectionList.value?.length) fetchConnectionList()
  })
  return { fetchConnectionList, connectionList }
}

// 所有资料
const materialList = ref<MaterialType[]>([])
export function useMaterial(experiment_id: string) {
  function fetchMaterialList() {
    getMaterialList({ experiment_id }).then((res: any) => {
      materialList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!materialList.value?.length) fetchMaterialList()
  })
  return { fetchMaterialList, materialList }
}
