import httpRequest from '@/utils/axios'

// 获取课程列表
export function getCourseList() {
  return httpRequest.get('/api/lab/v1/student/course/all')
}

// 获取实验详情
export function getExperiment(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment/detail', { params })
}

// 获取实验案例原文
export function getExperimentCase(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-cases/detail', { params })
}

// 获取实验指导书
export function getExperimentBookList(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-book/list', { params })
}

// 获取实验视频
export function getExperimentVideoList(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-video/all', { params })
}
// 获取实验视频播放信息
export function getExperimentVideoPlayInfo(params: { source_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-video/replay-list', { params })
}

// 获取实验讨论交流
export function getExperimentDiscussList(params: {
  experiment_id: string
  tag: number
  page?: number
  'per-page'?: number
}) {
  return httpRequest.get('/api/lab/v1/student/experiment-topic/list', { params })
}
// 发表新话题
export function addExperimentDiscuss(data: { experiment_id: string; title: string; content: string }) {
  return httpRequest.post('/api/lab/v1/student/experiment-topic/issue', data)
}
// 发表回复
export function addExperimentDiscussComment(data: { discussion_id: string; content: string }) {
  return httpRequest.post('/api/lab/v1/student/experiment-topic/comment', data)
}

// 获取实验记录
export function getExperimentRecord(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-record/detail', { params })
}

// 截图
export function uploadExperimentPicture(data: { experiment_id: string; pictures: string }) {
  return httpRequest.post('/api/lab/v1/student/experiment-record/upload-pictures', data)
}

// 上传实验报告
export function uploadExperimentReport(data: { experiment_id: string; file: string }) {
  return httpRequest.post('/api/lab/v1/student/experiment-record/upload-report', data)
}

// 提交实验记录
export function submitExperimentRecord(data: { experiment_id: string }) {
  return httpRequest.post('/api/lab/v1/student/experiment-record/submit', data)
}

// 获取实验准备详情
export function getExperimentPrepare(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment/pre-detail', { params })
}
// 更新实验准备
export function updateExperimentPrepare(data: { experiment_id: string; detail: string }) {
  return httpRequest.post('/api/lab/v1/student/experiment/pre-save', data)
}

// 获取实验结果详情
export function getExperimentResult(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment/result-detail', { params })
}
// 更新实验结果
export function updateExperimentResult(data: { experiment_id: string; detail: string }) {
  return httpRequest.post('/api/lab/v1/student/experiment/result-save', data)
}

// 获取实验报告模板
export function getExperimentReportTemplate(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment/report-template', { params })
}
// 更新实验在线报告
export function updateExperimentReport(data: {
  experiment_id: string
  experiment_address: string
  experiment_date: string
  detail: string
}) {
  return httpRequest.post('/api/lab/v1/student/experiment/upload-online-report', data)
}
// 缓存实验在线报告
export function cacheExperimentReport(data: {
  experiment_id: string
  experiment_address: string
  experiment_date: string
  detail: string
}) {
  return httpRequest.post('/api/lab/v1/student/experiment/cache-online-report', data)
}
// 获取实验在线报告缓存
export function getExperimentReportCache(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment/online-report-cached', { params })
}
// 获取实验在线报告详情
export function getExperimentReport(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment/online-report-detail', { params })
}

// 获取实验成绩
export function getExperimentScore(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment/achievement', { params })
}

// 获取实验试题列表
export function getExperimentQuestionList(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-question/list', { params })
}

// 获取实验试题详情
export function getExperimentQuestion(params: { experiment_id: string; id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-question/detail', { params })
}

// 获取实验理论考试列表
export function getExperimentExamList(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-exam/exams', { params })
}

// 学生查看分数详情页面
export function getExperimentScoreDetail(params: { experiment_id: string; type: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-question/score-detail', { params })
}

// 获取实验案例详情（包含步骤数据）
export function getExperimentCaseDetail(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-cases2/detail', { params })
}

// 获取实验案例示例数据
export function getExperimentExample(params: { experiment_id: string }) {
  return httpRequest.get('/api/lab/v1/student/experiment-cases2/detail', { params })
}

// 获取实验大赛信息
export function getExperimentCompetition(params: { experiment_id: string }) {
  // return {
  //   code: 0,
  //   message: 'OK',
  //   data: {
  //     detail: {
  //       experiment_id: '7264836112785342464',
  //       name: 'test',
  //       start_time: '2025-11-01 00:00:00',
  //       end_time: '2025-11-11 00:00:00',
  //       questions: '1',
  //     },
  //   },
  // }
  return httpRequest.get('/api/lab/v1/experiment/competition/detail', { params })
}

// 提交考试
export function submitCompetition(data: { experiment_id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/competition/submit', data)
}
