import { createApp } from 'vue'
import { createPinia } from 'pinia'
import { createHead } from '@unhead/vue/client'

import App from './App.vue'
import router from './router'

import ElementPlus from 'element-plus'
import '@/assets/styles/element/index.scss'
import zhCn from 'element-plus/es/locale/lang/zh-cn'
import AppCard from '@/components/base/AppCard.vue'
import AppList from '@/components/base/AppList.vue'
import AppUpload from '@/components/base/AppUpload.vue'

import modules from './modules'

import { permissionDirective } from '@/utils/permission'

const app = createApp(App)
const head = createHead()
// 注册公共组件
app.component('AppCard', AppCard).component('AppList', AppList).component('AppUpload', AppUpload)
app.directive('permission', permissionDirective)
// 注册模块
modules({ router })

app.use(createPinia())
app.use(router)
app.use(head)
app.use(ElementPlus, { locale: zhCn })

app.mount('#app')
