import httpRequest from '@/utils/axios'
import type { ContestJoinParams } from './types'

// 获取学员可以报名的所有赛项
export function getContestList() {
  return httpRequest.get('/api/lab/v1/student/competition/list')
}

// 获取学员已报名的赛项列表
export function getMyContestList() {
  return httpRequest.get('/api/lab/v1/student/competition/my-list')
}

// 获取赛项详情
export function getContest(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/student/competition/detail', { params })
}

// 获取学员详情
export function getStudentInfo() {
  return httpRequest.get('/api/lab/v1/student/competition/student-detail')
}

// 分发参赛短信
export function sendApplySMS(data: { competition_id: string; mobile: string }) {
  return httpRequest.post('/api/lab/v1/student/competition/send-apply-sms', data)
}

// 大赛报名
export function joinContest(data: ContestJoinParams) {
  return httpRequest.post('/api/lab/v1/student/competition/apply', data)
}

// 获取实验指导书
export function getExperimentBook(params: { competition_id: string }) {
  return httpRequest.get('/api/lab/v1/student/competition/book', { params })
}

// 获取实验指导书
export function getExperimentBooks(params: { competition_id: string; platform_key: string }) {
  return httpRequest.get('/api/lab/v1/student/competition/books', { params })
}

// 获取实验视频
export function getExperimentVideoList(params: { competition_id: string }) {
  return httpRequest.get('/api/lab/v1/student/competition/videos', { params })
}
// 获取实验视频播放信息
export function getExperimentVideoPlayInfo(params: { source_id: string }) {
  return httpRequest.get('/api/lab/v1/student/competition/replay-list', { params })
}

// 获取实验讨论交流
export function getExperimentDiscussList(params: { competition_id: string; tag: number; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/lab/v1/student/competition/discussion-list', { params })
}
// 发表新话题
export function addExperimentDiscuss(data: { competition_id: string; title: string; content: string }) {
  return httpRequest.post('/api/lab/v1/student/competition/discussion-create', data)
}
// 发表回复
export function addExperimentDiscussComment(data: { discussion_id: string; content: string }) {
  return httpRequest.post('/api/lab/v1/student/competition/discussion-reply-create', data)
}

// 获取实验截图记录
export function getExperimentRecord(params: { competition_id: string }) {
  return httpRequest.get('/api/lab/v1/student/competition/pictures', { params })
}
// 截图
export function uploadExperimentPicture(data: { competition_id: string; pictures: string }) {
  return httpRequest.post('/api/lab/v1/student/competition/save-pictures', data)
}

// 参赛选手训练计数
export function updateTrainCount(data: { competition_id: string }) {
  return httpRequest.post('/api/lab/v1/student/competition/train-count', data)
}

// 成绩查询
export function getScoreReport(params: { competition_id: string }) {
  return httpRequest.get('/api/lab/v1/student/competition/score-report2', { params })
}

// 获取实验报告
export function getExperimentReport(params: { competition_id: string; platform_key: string }) {
  return httpRequest.get('/api/lab/v1/student/competition/train-report', { params })
}

// 上传实验报告
export function uploadExperimentReport(data: { competition_id: string; platform_key: string; name: string; url: string; size: number; desc: string }) {
  return httpRequest.post('/api/lab/v1/student/competition/save-train-report', data)
}

// 删除实验报告
export function deleteExperimentReport(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/student/competition/delete-train-report', data)
}

// 获取实操试卷
export function getExperimentExam(params: { competition_id: string; platform_key: string; project: string }) {
  return httpRequest.get('/api/lab/v1/student/competition/train-exams', { params })
}
