// json to array
export const json2Array = function (data: any, isValueToNumber = true) {
  return Object.keys(data).map((value) => ({ label: data[value], value: isValueToNumber ? parseInt(value) : value }))
}

// 参赛模式
export const contestMode: Record<string, any> = {
  '1': '个人赛',
}
// 参赛模式列表
export const contestModeList = json2Array(contestMode, false)

// 评分规则
export const scoreRule: Record<number, any> = {
  1: '平均法',
  2: '加权平均法',
  3: '综合得分法',
  4: '最高分',
}
// 参赛模式列表
export const scoreRuleList = json2Array(scoreRule, false)

// 实验成绩规则
export const gradeRule: Record<number, any> = {
  1: '实验报告',
  2: '实验准备',
  3: '实验结果',
  4: '课堂活跃度',
  5: '自定义',
  6: '用户标签',
  7: '用户群组',
  8: '用户旅程',
  9: '营销资料',
  10: '用户/事件数据',
  11: '用户数据',
  12: '事件数据',
}
// 参赛模式列表
export const gradeRuleList = json2Array(gradeRule)

// 实验报告评分规则
export const reportScoreRule: Record<number, any> = {
  1: '人工评分',
  2: '自动评分',
}
export const reportScoreRuleList = json2Array(reportScoreRule)
