export interface Contestant {
  id: string
  competition_id: string
  student_id: string
  mode: string
  picture: string
  login_id: string
  init_pass: string
  grade: string
  teacher_name: string
  train_count: string
  commit_time: string
  commit_status: string
  score: string
  score_status: string
  created_time: string
  updated_time: string
  student: Student
  competition: {
    id: string
    name: string
  }
}
export interface Student {
  id: string
  sso_id: string
  id_type: string
  id_number: string
  organ_id: string
  sno_number: string
  name: string
  mobile: string
  gender: string
  birthday: string
  province: string
  city: string
  county: string
  specialty_id: string
  status: string
  created_operator: string
  updated_operator: string
  created_time: string
  updated_time: string
  delete_time: string
  info: {
    id: string
    province_id: string
    city_id: string
    county_id: string
    province_name: string
    city_name: string
    county_name: string
    status: string
    birthday: string
  }
  class: {
    id: string
    name: string
    student_id: string
  }
  org: Org
  specialty: {
    name: string
    id: string
  }
}
export interface Org {
  department_name: string
  project_id: string
  project_name: string
}

export type ContestantCreateParams = {
  competition_id: string
  mode: string
  picture?: string
  grade: string
  teacher_name: string
  mobile: string
  student_name: string
}
export type ContestantUpdateParams = {
  id: string
  mode: string
  picture?: string
  grade: string
  teacher_name: string
}
