import { useGetCourseList } from './useGetCourseList'
import type { ExperimentType } from '../types'
import { getExperiment, getExperimentCompetition, submitCompetition } from '../api'

interface StudentStatus {
  has_submitted: boolean
}

interface Competition {
  name: string
  start_time: string
  end_time: string
  student_status: StudentStatus
  competition: string
  questions: string
}

export function useCompetition() {
  const competition = ref<Competition>()
  const { courses } = useGetCourseList()
  const experiments = ref<ExperimentType[]>([])
  const courseId = ref('')
  const experimentId = ref('')

  watchEffect(() => {
    if (courses.value.length) {
      courseId.value = courses.value[0].id
      experiments.value = courses.value[0].experiments
    }
  })
  watchEffect(() => {
    if (experiments.value.length) {
      experimentId.value = experiments.value[0].id
    }
  })
  const experimentInfo = ref<ExperimentType>()
  const fetchExperiment = async () => {
    return false
    const res = await getExperiment({ experiment_id: experimentId.value })
    experimentInfo.value = res.data.detail
  }
  const fetchExperimentCompetition = async () => {
    const res = await getExperimentCompetition({ experiment_id: experimentId.value })
    competition.value = res.data.detail
  }
  watchEffect(() => {
    if (experimentId.value) {
      fetchExperiment()
      fetchExperimentCompetition()
    }
  })
  const submit = async () => {
    await submitCompetition({ experiment_id: experimentId.value })
    await fetchExperimentCompetition()
  }
  return { competition, courseId, experimentId, experimentInfo, submit }
}
