export interface DmlMenu {
  id: number
  name: string
  is_checked: boolean
  pid: number
  children?: DmlMenu[]
  path?: string
}

export const dmlMenus: DmlMenu[] = [
  {
    id: 1,
    name: '基础配置',
    is_checked: false,
    pid: 0,
    path: '/connect',
    children: [
      { id: 2, name: '连接管理', is_checked: false, pid: 1, path: '/connect', children: [] },
      { id: 3, name: '用户属性管理', is_checked: false, pid: 1, path: '/metadata/user', children: [] },
      { id: 4, name: '事件属性管理', is_checked: false, pid: 1, path: '/metadata/event', children: [] },
    ],
  },
  {
    id: 5,
    name: '营销策划',
    is_checked: false,
    pid: 0,
    path: '/market/my',
    children: [],
  },
  {
    id: 6,
    name: '用户画像',
    is_checked: false,
    pid: 0,
    path: '/user',
    children: [],
  },
  {
    id: 7,
    name: '用户识别',
    is_checked: false,
    pid: 0,
    path: '/label',
    children: [
      { id: 8, name: '标签管理', is_checked: false, pid: 7, path: '/label', children: [] },
      { id: 9, name: '群组管理', is_checked: false, pid: 7, path: '/group', children: [] },
      { id: 71, name: '运营策略管理', is_checked: false, pid: 7, path: '/strategy', children: [] },
    ],
  },
  {
    id: 10,
    name: '营销内容设计',
    is_checked: false,
    pid: 0,
    path: '/material',
    children: [
      { id: 11, name: '文本资料管理', is_checked: false, pid: 10, path: '/material?type=1', children: [] },
      { id: 12, name: '图片资料管理', is_checked: false, pid: 10, path: '/material?type=2', children: [] },
      { id: 13, name: '卡券资料管理', is_checked: false, pid: 10, path: '/material?type=8', children: [] },
      { id: 14, name: '视频资料管理', is_checked: false, pid: 10, path: '/material?type=4', children: [] },
      { id: 15, name: 'H5资料管理', is_checked: false, pid: 10, path: '/material?type=5', children: [] },
      { id: 16, name: '二维码资料管理', is_checked: false, pid: 10, path: '/material?type=6', children: [] },
      { id: 17, name: '语音资料管理', is_checked: false, pid: 10, path: '/material?type=3', children: [] },
      { id: 18, name: '小程序资料管理', is_checked: false, pid: 10, path: '/material?type=7', children: [] },
    ],
  },
  {
    id: 19,
    name: '自动化营销',
    is_checked: false,
    pid: 0,
    path: '/trip/my',
    children: [],
  },
  {
    id: 20,
    name: '直播带货',
    is_checked: false,
    pid: 0,
    path: '/live',
    children: [
      { id: 21, name: '商品品类管理', is_checked: false, pid: 20, path: '/live/product/category', children: [] },
      { id: 22, name: '商品属性管理', is_checked: false, pid: 20, path: '/live/product/attr', children: [] },
      { id: 23, name: '商品管理', is_checked: false, pid: 20, path: '/live/product/management', children: [] },
      { id: 24, name: '直播练习', is_checked: false, pid: 20, path: '/live/test', children: [] },
      { id: 25, name: '直播话术管理', is_checked: false, pid: 20, path: '/live/talk', children: [] },
      { id: 201, name: '订单管理', is_checked: false, pid: 20, path: '/live/order', children: [] },
      { id: 202, name: '直播总结管理', is_checked: false, pid: 20, path: '/live/reports', children: [] },
      { id: 203, name: '成绩管理', is_checked: false, pid: 20, path: '/live/score', children: [] },
    ],
  },
  {
    id: 26,
    name: '数据分析',
    is_checked: false,
    pid: 0,
    path: '/analyze',
    children: [
      { id: 27, name: '用户分析', is_checked: false, pid: 26, path: '/analyze/user', children: [] },
      { id: 28, name: '标签群组分析', is_checked: false, pid: 26, path: '/analyze/label', children: [] },
      { id: 29, name: '事件分析', is_checked: false, pid: 26, path: '/analyze/event', children: [] },
      { id: 30, name: '营销分析', is_checked: false, pid: 26, path: '/analyze/marketing', children: [] },
    ],
  },
  {
    id: 40,
    name: '全媒体运营',
    is_checked: false,
    pid: 0,
    path: '/operations',
    children: [
      { id: 401, name: '创意策划方案', is_checked: false, pid: 40, path: '/operations/plan', children: [] },
      { id: 402, name: '视听运营', is_checked: false, pid: 40, path: '/operations/audiovisual', children: [] },
      { id: 403, name: '流量运营', is_checked: false, pid: 40, path: '/operations/flow', children: [] },
      { id: 404, name: '成绩管理', is_checked: false, pid: 40, path: '/live/score', children: [] },
    ],
  },
]
