import httpRequest from '@/utils/axios'

// 获取赛项列表
export function getCompetitionItems() {
  return httpRequest.get('/api/lab/v1/expert/competition/items')
}

// 获取赛项的统计详情
export function getCompetitionStatistics(params: { competition_id: string; platform_key: string }) {
  return httpRequest.get('/api/lab/v1/expert/competition/statistics', { params })
}

// 获取所有的参赛学员列表
export function getCompetitionCompetitors(params: { competition_id: string; platform_key: string }) {
  return httpRequest.get('/api/lab/v1/expert/competition/competitors', { params })
}

// 获取平台标识列表
export function getPlatformKeys(params?: { competition_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-book/platform-keys', { params })
}
