export interface CaseItem {
  created_operator: CaseOperator
  created_time: string
  delete_time: string
  course: {
    id: string
    name: string
  }
  experiment: {
    id: string
    name: string
  }
  experiment_id: string
  id: string
  name: string
  pv: string
  size: string
  status: string
  type: string
  updated_operator: CaseOperator
  updated_time: string
  url: string
}

export interface CaseOperator {
  avatar: string
  id: string
  nickname: string
  real_name: string
  username: string
}

export interface CaseFormData {
  id?: string
  experiment_id: string
  course_id: string
  status: string
  name: string
  type: string
  url: string
  size: string
  protocol: boolean
  files: FileItem[]
}

export type CaseCreateItem = Pick<CaseFormData, 'experiment_id' | 'status' | 'name' | 'type' | 'url' | 'size'>

export type CaseUpdateItem = CaseCreateItem & { id?: string }

export interface FileItem {
  name: string
  url: string
  raw?: File
  type?: string
  size?: number
}
