import httpRequest from '@/utils/axios'

// 获取赛项抽签规则详情
export function getDrawLot(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-draw/draw-rule', { params })
}

// 检索赛项抽签学员的信息
export function searchStudent(params: { id_number: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-draw/search-student', { params })
}

// 赛项抽签
export function postDrawLot(data: { draw_rule_id: string; student_id: string }) {
  return httpRequest.post('/api/resource/v1/backend/competition-draw/draw', data)
}

// 获取学员的抽签详情
export function getStudentDrawLotInfo(params: { draw_rule_id: string; student_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-draw/student-draw-info', { params })
}
