import httpRequest from '@/utils/axios'

// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/lab/v1/common/permission/role')
}

// 退出登录
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}

// 获取oss token
export function getToken() {
  return httpRequest.get('/api/usercenter/aliyun/assume-role')
}

// 获取oss signature
export function getSignature() {
  return httpRequest.get('/api/usercenter/aliyun/get-signature')
}

// 图片上传
export async function uploadFile(data: Record<string, any>) {
  await httpRequest.post(data.host || 'https://webapp-pub.ezijing.com', data, {
    withCredentials: false,
    headers: { 'Content-Type': 'multipart/form-data' }
  })
  return data
}
// 获取公共字典列表
export function getMapList() {
  return httpRequest.get('/api/resource/v1/util/get-data-dictionary-list')
}

// 获取上传视频凭证
export function getUploadVideoAuth(data: { title: string; file_name: string }) {
  return httpRequest.post('/api/lab/v1/teacher/video/auth-create', data)
}

// 刷新上传视频的地址凭证
export function updateUploadVideoAuth(data: { source_id: string }) {
  return httpRequest.post('/api/lab/v1/teacher/video/create-auth', data)
}

// 获取项目列表
export function getProjectList(params: { organization_id?: string; project_id?: string }) {
  return httpRequest.get('/api/resource/v1/util/members', { params })
}

// 获取赛项列表
export function getContestList(params?: { name?: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition/menu-list', { params })
}

// 获取待办消息
// https://gitlab.ezijing.com/root/api-documents/-/blob/master/messages/api/%E4%B8%80%E6%9C%9F%E7%AB%99%E5%86%85%E4%BF%A1%E6%8E%A5%E5%8F%A3%E6%96%87%E6%A1%A3.md#%E8%8E%B7%E5%8F%96%E7%AB%99%E5%86%85%E4%BF%A1%E6%B6%88%E6%81%AF%E5%88%97%E8%A1%A8
export function getMessages(params: {
  source: string
  page?: number
  limit?: number
  is_read?: 0 | 1 | 9999
  is_platform?: 0 | 1 | 9999
  start_time?: string
  end_time?: string
}) {
  return httpRequest.get('/api/msg/v1/messages/intra-station-messages', {
    params
  })
}

export function readMessages(params: { message_id: string }) {
  return httpRequest.get('/api/msg/v1/messages/read', {
    params
  })
}

// 获取分片大小和唯一文件名
export function getLocalFileChunk(params: { file_size: number; file_name: string }) {
  return httpRequest.get('/api/lab/v1/common/file/chunk', { params })
}

// 上传每个分片前请求接口来获取当前文件是否超时,之前的分片是否被清理,如果被请求则拒绝处理。返回客户端错误码，让客户端户端不再续传剩余分片
// 1文件被清理 0文件未被清理
export function checkLocalFile(params: { file_name: string }) {
  return httpRequest.get('/api/lab/v1/common/file/check', { params })
}

// 上传文件
export function uploadLocalFile(
  data: { file: File | Blob; file_name: string; is_continuingly?: number; now_package_num: number; total_package_num: number },
  options = {}
) {
  return httpRequest.post(
    '/api/lab/v1/common/file/upload',
    data,
    Object.assign({ withCredentials: false, headers: { 'Content-Type': 'multipart/form-data' } }, options)
  )
}
