import httpRequest from '@/utils/axios'
import type { ExpertCreateParams, ExpertUpdateParams } from './types'

// 获取评分专家列表
export function getExpertList(params?: { name?: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/expert/list', { params })
}

// 获取评分专家详情
export function getExpert(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/backend/expert/detail', { params })
}

// 创建评分专家
export function createExpert(data: ExpertCreateParams) {
  return httpRequest.post('/api/resource/v1/backend/expert/create', data)
}

// 修改评分专家
export function updateExpert(data: ExpertUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/expert/update', data)
}

// 修改评分专家
export function importExpert(data: { file: File }) {
  return httpRequest.post('/api/resource/v1/backend/expert/import-exports', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

// 获取评分专家赛项列表
export function getExpertContestList(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/backend/expert/competitions', { params })
}
