import { getTeacherList } from '../api'

interface TeacherType {
  id: string
  name: string
}
const teachers = ref<TeacherType[]>([])

export function useGetTeacherList() {
  !teachers.value.length &&
    getTeacherList({ 'per-page': 1000 }).then((res: any) => {
      teachers.value = res.data.list
    })
  return { teachers }
}
