import httpRequest from '@/utils/axios'
import type { CaseCreateItem } from './types'

// 获取课程列表
export function getCourseList() {
  return httpRequest.get('/api/lab/v1/teacher/course/list')
}
// 获取实验列表
export function getExperimentList(params: { course_id?: string }) {
  return httpRequest.get('/api/lab/v1/teacher/experiment-cases/experiments', { params })
}
// 获取案例原文列表
export function getCaseList(params?: { name?: string; experiment_id?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/lab/v1/teacher/experiment-cases/list', { params })
}
// 获取案例原文详情
export function getCase(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/experiment-cases/detail', { params })
}

// 创建案例原文
export function createCase(data: CaseCreateItem) {
  return httpRequest.post('/api/lab/v1/teacher/experiment-cases/create', data)
}

// 更新案例原文
export function updateCase(data: CaseCreateItem) {
  return httpRequest.post('/api/lab/v1/teacher/experiment-cases/update', data)
}
