import { useUserStore } from '@/stores/user'
import type { DirectiveBinding } from 'vue'

// 判断是否有权限
export function checkPermission(value: string | string[]): boolean {
  const userStore = useUserStore()
  const permissions = userStore.permissions
  if (Array.isArray(value)) {
    return permissions.some(item => value.includes(item.tag))
  } else {
    return !!permissions.find(item => item.tag === value)
  }
}

// 权限指令
export function permissionDirective(el: HTMLElement, binding: DirectiveBinding) {
  const { value } = binding
  if (!value) return
  if (!checkPermission(value)) {
    el.parentNode && el.parentNode.removeChild(el)
  }
}
