import axios from 'axios'
import { getLocalFileChunk, uploadLocalFile } from '@/api/base'

export async function upload(file: Blob) {
  const response = await getLocalFileChunk({ file_name: 'abc', file_size: file.size })
  const params = {
    file,
    file_name: response.data.detail.file_name,
    now_package_num: 1,
    total_package_num: 1
  }
  const res = await uploadLocalFile(params)

  return res.data.detail.uri
}

export async function uploadFileByUrl(url: string) {
  const res = await axios.get(url, { responseType: 'blob' })
  return upload(res.data)
}
