import Vue from 'vue'
import Vuex from 'vuex'

Vue.use(Vuex)

const store = new Vuex.Store({
  state: {
    user: {},
    isIos: /iphone|ipad|ipod/i.test(navigator.userAgent),
    isAndroid: /android/i.test(navigator.userAgent),
    isWeapp: /miniProgram/.test(navigator.userAgent)
  },
  mutations: {
    setUser(state, user) {
      state.user = user
    },
    setIsWeapp(state, isWeapp) {
      state.isWeapp = isWeapp
    }
  },
  actions: {}
})

export default store
