import axios from 'axios'
import qs from 'qs'

const httpRequest = axios.create({
  timeout: 60000,
  withCredentials: true,
  headers: {
    'Content-Type': 'application/x-www-form-urlencoded'
  }
})

// 请求拦截
httpRequest.interceptors.request.use(
  function (config) {
    if (config.headers['Content-Type'] === 'application/x-www-form-urlencoded') {
      config.data = qs.stringify(config.data)
    }
    return config
  },
  function (error) {
    return Promise.reject(error)
  }
)

// 响应拦截
httpRequest.interceptors.response.use(
  function (response) {
    const { data } = response
    if (data.code) {
      window.alert(data.msg)
      return Promise.reject(data)
    }
    return data
  },
  function (error) {
    console.log(error.response)
    if (error.response) {
      const { message } = error.response.data
      window.alert(message || error.response.data)
      return Promise.reject(error.response)
    } else {
      window.alert(error)
    }
    return Promise.reject(error)
  }
)

export default httpRequest
